/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.ConfigCustDataRepBean;
import com.ibm.hwmca.base.saverest.ConfigDataRepConstants;
import com.ibm.hwmca.base.saverest.ConfigNewRepSourceBean;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.saverest.SaveRestoreErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class ConfigDataRepTasklet
extends PanelTasklet
implements ConfigDataRepConstants,
SaveRestoreErrorIds {
    private static final String TRACE_MASKT = "XCDRTSKT";
    private static final String TRACE_MASKF = "XCDRTSKF";
    private static final String TRACE_MASKD = "XCDRTSKD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(37, "ConfigDataRep");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.saverest.res.Saveres";
    private static final String CONFIG_CUST_DATA_REP_PANEL_NAME = "ConfigCustDataRepPanel";
    private static final String CONFIG_NEW_REP_SOURCE_PANEL_NAME = "ConfigNewRepSourcePanel";
    private ConfigCustDataRepBean confDataRepBean = new ConfigCustDataRepBean();
    private ConfigNewRepSourceBean newSourceDataRepBean = new ConfigNewRepSourceBean();
    private DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private TreeMap hmcSources;
    private TreeMap confDataSources;
    private TreeMap customData;
    private String[] dispDataTypesName;
    private String[] keyDataTypes;
    private int[] warnings;
    String[] selEnable = new String[1];
    private TreeMap mapIPaddr = new TreeMap();
    private TreeMap consoles = new TreeMap();
    private static BaseMessageTitle title = new BaseMessageTitle("DATAREP1.TITLE");
    private static BaseMessageText text = new BaseMessageText("DATAREP1");
    private static BaseMessageText delText = new BaseMessageText("DATAREP4");
    private static BaseMessageTitle busytitle = new BaseMessageTitle("DATAREP1.BUSY.TITLE");
    private static BaseMessageTitle busytext = new BaseMessageTitle("DATAREP1.BUSY.MSG");
    private static TreeMap initSrcCnt = new TreeMap();

    public ConfigDataRepTasklet() {
        Trace.trace(TRACE_MASKT, "<> ConfigDataRepTasklet.ConfigDataRepTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConfigDataRepTasklet.service(" + request + ", " + response + ")");
        if (request.isInitialRequest()) {
            this.confDataRepBean.setBeanName("ConfigCustDataRepBean");
            this.newSourceDataRepBean.setBeanName("ConfigNewRepSourceBean");
            this.selEnable = this.dataRepApp.isDataRepEnabled() ? new String[]{"EnableItem"} : new String[]{"DisableItem"};
            this.confDataRepBean.setInitEnableDisableSelection(this.selEnable);
            this.customData = this.dataRepApp.getTreeData();
            int i = 0;
            int warningsCnt = 0;
            this.keyDataTypes = new String[this.customData.size()];
            this.dispDataTypesName = new String[this.customData.size()];
            Set keys = this.customData.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                this.keyDataTypes[i] = (String)it.next();
                Object[] objArray = (Object[])this.customData.get(this.keyDataTypes[i]);
                if (((Boolean)objArray[1]).booleanValue()) {
                    ++warningsCnt;
                }
                initSrcCnt.put(this.keyDataTypes[i], Integer.valueOf("0"));
                this.dispDataTypesName[i] = (String)objArray[4];
                ++i;
            }
            this.confDataRepBean.setItemWarnDescriptorInfo(this.dispDataTypesName);
            this.warnings = new int[warningsCnt];
            i = 0;
            int k = 0;
            Iterator it2 = keys.iterator();
            while (it2.hasNext()) {
                Object[] objArray = (Object[])this.customData.get((String)it2.next());
                if (((Boolean)objArray[1]).booleanValue()) {
                    this.warnings[k] = i;
                    ++k;
                }
                ++i;
            }
            this.confDataRepBean.setInitLocalCustWarnTableSelection(this.warnings);
            FcsServer server = FcsServer.getFcsServer();
            MachineId myMachine = server.getLocalMachineId();
            FcsServiceId id = new FcsServiceId("Data Replication Application", 1.0);
            Set machineSet = FcsServer.getFcsServer().getSupportingMachines(id);
            Iterator it3 = machineSet.iterator();
            while (it3.hasNext()) {
                MachineId mach = (MachineId)it3.next();
                String machName = mach.getName();
                InetAddress[] inetAddress = mach.getNicAddresses();
                String[] ipAddrArray = new String[inetAddress.length];
                int m = 0;
                while (m < inetAddress.length) {
                    ipAddrArray[m] = inetAddress[m].getHostAddress();
                    ++m;
                }
                this.mapIPaddr.put(machName, ipAddrArray);
                this.consoles.put(machName, null);
            }
            this.mapIPaddr.remove(myMachine.getName());
            this.consoles.remove(myMachine.getName());
            this.hmcSources = this.dataRepApp.getHmcSources();
            this.confDataSources = new TreeMap();
            Set hmcKeys = this.hmcSources.keySet();
            Iterator it4 = hmcKeys.iterator();
            while (it4.hasNext()) {
                String dataSource = (String)it4.next();
                Object[] objArray = (Object[])this.hmcSources.get(dataSource);
                String[] selSources = (String[])objArray[1];
                int[] intArray = new int[selSources.length];
                int j = 0;
                while (j < selSources.length) {
                    int l = 0;
                    while (l < this.keyDataTypes.length) {
                        if (selSources[j].equals(this.keyDataTypes[l])) {
                            intArray[j] = l;
                            break;
                        }
                        ++l;
                    }
                    Integer srcCnt = (Integer)initSrcCnt.get(selSources[j]);
                    srcCnt = new Integer(srcCnt + 1);
                    initSrcCnt.put(selSources[j], srcCnt);
                    ++j;
                }
                this.confDataSources.put(dataSource, intArray);
                String[] confIPaddr = (String[])objArray[0];
                this.mapIPaddr.put(dataSource, confIPaddr);
                this.consoles.remove(dataSource);
            }
            this.confDataRepBean.setInitDataSourceChoiceList(this.confDataSources);
            this.confDataRepBean.setOrigSettings(this.selEnable, this.confDataSources, this.warnings);
            ArrayList<String> tempArray = new ArrayList<String>();
            Set dataTypes = initSrcCnt.keySet();
            Iterator it5 = dataTypes.iterator();
            while (it5.hasNext()) {
                String dataKind = (String)it5.next();
                Integer oldCnt = (Integer)initSrcCnt.get(dataKind);
                if (oldCnt == 0) continue;
                tempArray.add(dataKind);
            }
            int l = 0;
            while (l < tempArray.size()) {
                initSrcCnt.remove((String)tempArray.get(l));
                ++l;
            }
            response.replace(AUIML_FILE_NAME, CONFIG_CUST_DATA_REP_PANEL_NAME, this.confDataRepBean);
        } else {
            String panelNum = (String)request.getData("Panel");
            TaskActionEvent event = (TaskActionEvent)request.getData("Event");
            if (panelNum.equals("1")) {
                if (event.getElementName().endsWith("SaveButton")) {
                    int i;
                    String[] enableDisableRBG = (String[])request.getData("EnableDisable");
                    if (!this.selEnable[0].equals(enableDisableRBG[0])) {
                        if (enableDisableRBG[0].equals("EnableItem")) {
                            this.dataRepApp.setDataRepEnabled(true);
                        } else {
                            this.dataRepApp.setDataRepEnabled(false);
                        }
                    }
                    int[] beanWarnings = (int[])request.getData("LocalCustWarnTable");
                    boolean warningsEqual = true;
                    if (beanWarnings.length == this.warnings.length) {
                        int i2 = 0;
                        while (i2 < beanWarnings.length) {
                            if (beanWarnings[i2] != this.warnings[i2]) {
                                warningsEqual = false;
                                break;
                            }
                            ++i2;
                        }
                    } else {
                        warningsEqual = false;
                    }
                    if (!warningsEqual) {
                        boolean[] selWarnings = new boolean[this.keyDataTypes.length];
                        i = 0;
                        while (i < beanWarnings.length) {
                            selWarnings[beanWarnings[i]] = true;
                            ++i;
                        }
                        this.dataRepApp.setCustomDataEnabled(this.keyDataTypes, selWarnings);
                    }
                    ArrayList delHmcSources = (ArrayList)request.getData("DelSources");
                    i = 0;
                    while (i < delHmcSources.size()) {
                        if (!this.hmcSources.containsKey((String)delHmcSources.get(i))) {
                            delHmcSources.remove(i);
                        }
                        ++i;
                    }
                    if (delHmcSources.size() > 0) {
                        String[] delHmcList = new String[delHmcSources.size()];
                        int i3 = 0;
                        while (i3 < delHmcSources.size()) {
                            delHmcList[i3] = (String)delHmcSources.get(i3);
                            ++i3;
                        }
                        this.dataRepApp.delHmcSource(delHmcList);
                    }
                    TreeMap beanMap = (TreeMap)request.getData("CustDataTypeTable");
                    Set beanKeys = beanMap.keySet();
                    Iterator it = beanKeys.iterator();
                    while (it.hasNext()) {
                        int i4;
                        String beanHost = (String)it.next();
                        int[] intArray = (int[])beanMap.get(beanHost);
                        if (initSrcCnt.size() > 0) {
                            int j = 0;
                            while (j < intArray.length) {
                                String dataSrc = this.keyDataTypes[intArray[j]];
                                if (initSrcCnt.containsKey(dataSrc)) {
                                    this.dataRepApp.setCustomDataLevel(dataSrc, -1L);
                                    initSrcCnt.remove(dataSrc);
                                }
                                ++j;
                            }
                        }
                        boolean writeChange = false;
                        if (this.confDataSources.containsKey(beanHost)) {
                            int[] oldArray = (int[])this.confDataSources.get(beanHost);
                            if (intArray.length == oldArray.length) {
                                i4 = 0;
                                while (i4 < intArray.length) {
                                    if (intArray[i4] != oldArray[i4]) {
                                        writeChange = true;
                                        break;
                                    }
                                    ++i4;
                                }
                            } else {
                                writeChange = true;
                            }
                        } else {
                            writeChange = true;
                        }
                        if (!writeChange) continue;
                        String[] dataSources = new String[intArray.length];
                        i4 = 0;
                        while (i4 < intArray.length) {
                            dataSources[i4] = this.keyDataTypes[intArray[i4]];
                            ++i4;
                        }
                        String[] IPaddr = (String[])this.mapIPaddr.get(beanHost);
                        this.dataRepApp.addHmcSource(beanHost, IPaddr, dataSources);
                    }
                    this.dataRepApp.setCustomDataConfigured();
                    response.terminate();
                } else if (event.getElementName().endsWith("CancelButton")) {
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setDisposed();
                    response.terminate();
                } else if (event.getElementName().endsWith("NewButton")) {
                    ArrayList delHmcSources = (ArrayList)request.getData("DelSources");
                    TreeMap beanMap = (TreeMap)request.getData("CustDataTypeTable");
                    int i = 0;
                    while (i < delHmcSources.size()) {
                        this.consoles.put(delHmcSources.get(i), null);
                        ++i;
                    }
                    Set beanKeys = beanMap.keySet();
                    Iterator it = beanKeys.iterator();
                    while (it.hasNext()) {
                        String beanHost = (String)it.next();
                        this.consoles.remove(beanHost);
                    }
                    String[] discConsoles = new String[this.consoles.size()];
                    this.consoles.keySet().toArray(discConsoles);
                    this.newSourceDataRepBean.setDiscoveredConsoleInfo(discConsoles);
                    response.openModalChild(AUIML_FILE_NAME, CONFIG_NEW_REP_SOURCE_PANEL_NAME, this.newSourceDataRepBean);
                }
            } else if (panelNum.equals("3")) {
                String[] beanEnableDisable = (String[])request.getData("EnableDisable");
                this.confDataRepBean.setInitEnableDisableSelection(beanEnableDisable);
                ArrayList delHmcSources = (ArrayList)request.getData("DelSources");
                this.confDataRepBean.setInitDeletedSources(delHmcSources);
                TreeMap beanMap = (TreeMap)request.getData("CustDataTypeTable");
                this.confDataRepBean.setInitDataSourceChoiceList(beanMap);
                int[] beanWarnings = (int[])request.getData("LocalCustWarnTable");
                this.confDataRepBean.setInitLocalCustWarnTableSelection(beanWarnings);
                response.replace(AUIML_FILE_NAME, CONFIG_CUST_DATA_REP_PANEL_NAME, this.confDataRepBean);
            } else if (event.getElementName().endsWith("FindButton")) {
                String ipAddr = (String)request.getData("IPAddrEdit");
                this.showBusyDialog(busytitle, busytext);
                MachineId newMachine = this.dataRepApp.isAddressConnectable(ipAddr);
                if (newMachine != null) {
                    InetAddress[] inetAddress = newMachine.getNicAddresses();
                    String[] ipAddrArray = new String[inetAddress.length];
                    int i = 0;
                    while (i < inetAddress.length) {
                        ipAddrArray[i] = inetAddress[i].getHostAddress();
                        ++i;
                    }
                    this.mapIPaddr.put(newMachine.getName(), ipAddrArray);
                    this.destroyBusyDialog();
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update(newMachine.getName());
                } else {
                    this.destroyBusyDialog();
                    LocalizableText selection = null;
                    selection = this.showMessageBox(true, title, text, null, null);
                    response.replace(AUIML_FILE_NAME, CONFIG_NEW_REP_SOURCE_PANEL_NAME, this.newSourceDataRepBean);
                }
            } else if (event.getElementName().endsWith("AddButton")) {
                String selected = (String)request.getData("DiscoveredConsoleChoice");
                response.setMultipleResponseMode();
                response.dispose();
                response.update(selected);
            } else if (event.getElementName().endsWith("CancelButton")) {
                response.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ConfigDataRepTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ConfigDataRepTasklet.logException(" + throwable + ")");
        new FrameworkLog(_logInfo, 8, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ConfigDataRepTasklet.logException()");
    }
}

